﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace TicTacDoh
{
    public partial class Form1 : Form
    {
        public static Nullable<char>[,] state;
        public static char current;
        public static Boolean draw;

        // 'X' == 88 || 264
        // 'Y' == 79 || 237

        public static int X_BUFFER = 15;
        public static int Y_BUFFER = 15;

        public Form1()
        {
            InitializeComponent();

            state = new Nullable<char>[3, 3];
            ResetTheBoard();
        }

        public void ResetTheBoard()
        {
            for (int i = 0; i < 3; i++)
                for (int j = 0; j < 3; j++)
                    state[i, j] = null;

            current = 'X';
            draw = true;
            GameBoard.Refresh();
        }

        public void DeclareTheWinner(char winner)
        {
            MessageBox.Show("The " + winner + "'s have won!");

            ResetTheBoard();
        }

        public void CheckForWinner()
        {
            int total;

            // Checking the columns
            for (int i = 0; i < 3; i++)
            {
                total = 0;
                for (int j = 0; j < 3; j++)
                {
                    if (state[i, j].HasValue)
                    {
                        total += (int)state[i, j];
                    }
                    else
                    {
                        draw = false;
                        break;
                    }
                }
                if (total == 264)
                    DeclareTheWinner('X');
                else if (total == 237)
                    DeclareTheWinner('O');
            }

            // Checking the rows
            for (int i = 0; i < 3; i++)
            {
                total = 0;
                for (int j = 0; j < 3; j++)
                {
                    if (state[j, i].HasValue)
                    {
                        total += (int)state[j, i];
                    }
                    else
                    {
                        draw = false;
                        break;
                    }
                }
                if (total == 264)
                    DeclareTheWinner('X');
                else if (total == 237)
                    DeclareTheWinner('O');
            }

            // Checking the diagonals
            // Top-left to bottom-right
            total = 0;
            for (int i = 0; i < 3; i++)
            {
                if (state[i, i].HasValue)
                {
                    total += (int)state[i, i];
                }
                else
                {
                    draw = false;
                    break;
                }
            }
            if (total == 264)
                DeclareTheWinner('X');
            else if (total == 237)
                DeclareTheWinner('O');

            // Top-right to bottom-left
            total = 0;
            for (int i = 0; i < 3; i++)
            {
                if (state[i, (2 - i)].HasValue)
                {
                    total += (int)state[i, (2 - i)];
                }
                else
                {
                    draw = false;
                    break;
                }
            }
            if (total == 264)
                DeclareTheWinner('X');
            else if (total == 237)
                DeclareTheWinner('O');

            if (draw)
            {
                MessageBox.Show("It's a draw!");
                ResetTheBoard();
            }
            else
                draw = true;
        }

        private void GameBoard_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            using (Pen myPen = new Pen(Color.BurlyWood))
            {
                g.DrawLine(myPen, GameBoard.Width / 3, 0,
                                  GameBoard.Width / 3, GameBoard.Height);
                g.DrawLine(myPen, (2 * GameBoard.Width / 3), 0,
                                  (2 * GameBoard.Width / 3), GameBoard.Height);

                g.DrawLine(myPen, 0, GameBoard.Height / 3,
                                  GameBoard.Width, GameBoard.Height / 3);
                g.DrawLine(myPen, 0, (2 * GameBoard.Height / 3),
                                  GameBoard.Width, (2 * GameBoard.Height / 3));


                for (int i = 0; i < 3; i++)
                    for (int j = 0; j < 3; j++)
                    {
                        if (state[i, j].HasValue)
                        {
                            if (state[i, j] == 'X')
                            {
                                g.DrawLine(myPen, 0 + ((GameBoard.Width / 3) * i) + X_BUFFER, 0 + ((GameBoard.Height / 3) * j) + Y_BUFFER,
                                                  (GameBoard.Width / 3) + ((GameBoard.Width / 3) * i) - X_BUFFER, (GameBoard.Height / 3) + ((GameBoard.Height / 3) * j) - Y_BUFFER);

                                g.DrawLine(myPen, 0 + ((GameBoard.Width / 3) * i) + X_BUFFER, (GameBoard.Height / 3) + ((GameBoard.Height / 3) * j) - Y_BUFFER,
                                                  (GameBoard.Width / 3) + ((GameBoard.Width / 3) * i) - X_BUFFER, 0 + ((GameBoard.Height / 3) * j) + Y_BUFFER);
                            }
                            else
                            {
                                // This is for when I'm drawing O's as circles
                                /*
                                if (GameBoard.Width < GameBoard.Height)
                                    g.DrawCircle(myPen, (GameBoard.Width / 6) + ((GameBoard.Width / 3) * i),
                                                        (GameBoard.Height / 6) + ((GameBoard.Height / 3) * j), (GameBoard.Width / 6) - X_BUFFER);
                                else
                                    g.DrawCircle(myPen, (GameBoard.Width / 6) + ((GameBoard.Width / 3) * i),
                                                        (GameBoard.Height / 6) + ((GameBoard.Height / 3) * j), (GameBoard.Height / 6) - Y_BUFFER);
                                */

                                // This is for when I'm drawing O's as ellipses
                                g.DrawEllipse(myPen, 0 + ((GameBoard.Width / 3) * i) + X_BUFFER, 0 + ((GameBoard.Height / 3) * j) + Y_BUFFER,
                                                     (GameBoard.Width / 3) - (X_BUFFER * 2), (GameBoard.Height / 3) - (Y_BUFFER * 2));
                            }
                        }
                    }
            }
        }

        private void GameBoard_MouseDown(object sender, MouseEventArgs e)
        {
            //MessageBox.Show(String.Format("[{0}][{1}]", e.X / (GameBoard.Width / 3),
            //                                            e.Y / (GameBoard.Height / 3)));

            if (!state[e.X / (GameBoard.Width / 3), e.Y / (GameBoard.Height / 3)].HasValue)
            {
                state[e.X / (GameBoard.Width / 3), e.Y / (GameBoard.Height / 3)] = current;

                if (current == 'X')
                    current = 'O';
                else
                    current = 'X';

                GameBoard.Refresh();
                CheckForWinner();
            }
            else
                MessageBox.Show("There's already a " + state[e.X / (GameBoard.Width / 3), e.Y / (GameBoard.Height / 3)] +
                                " character at this cell. Please choose again.");
        }

        private void Form1_ResizeEnd(object sender, EventArgs e)
        {
            GameBoard.Width = this.Width - (40);
            GameBoard.Height = this.Height - (60);
            GameBoard.Refresh();
        }
    }

    public static class GraphicsExtensions
    {
        public static void DrawCircle(this Graphics g, Pen pen,
                                      float centerX, float centerY, float radius)
        {
            g.DrawEllipse(pen, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }

        public static void FillCircle(this Graphics g, Brush brush,
                                      float centerX, float centerY, float radius)
        {
            g.FillEllipse(brush, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }
    }
}
