﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;

namespace Reflexes
{
    public partial class Form1 : Form
    {
        public static object poolLock;
        public static List<Test> pool;
        public static int counter = 0;
        public static long totalTime = 0;

        public static int YELLOW_THRESHOLD = 1500;

        public static System.Windows.Forms.Timer generateTimer;
        public static System.Windows.Forms.Timer colorTimer;

        public static Random rng;

        public Form1()
        {
            InitializeComponent();

            rng = new Random();
            pool = new List<Test>();
            poolLock = new object();

            generateTimer = new System.Windows.Forms.Timer();
            //generateTimer.Enabled = true;
            generateTimer.Interval = 1000;
            generateTimer.Tick += new EventHandler(createTests);

            colorTimer = new System.Windows.Forms.Timer();
            //colorTimer.Enabled = true;
            colorTimer.Interval = 250;
            colorTimer.Tick += new EventHandler(changeColors);

            //pool.Add(new Test(100, 100, 40));
            //pool.Add(new Test(300, 300, 60));
        }

        public void createTests(object sender, EventArgs e)
        {
            int slackerR = rng.Next(31) + 30; // [30, 60]

            pool.Add(new Test(slackerR + rng.Next(Canvas.Width - (slackerR * 2)),
                              slackerR + rng.Next(Canvas.Height - (slackerR * 2)),
                              slackerR));

            generateTimer.Interval = rng.Next(1500) + 500;
            Canvas.Refresh();
        }

        public void changeColors(object sender, EventArgs e)
        {
            lock (poolLock)
            {
                foreach (Test i in pool.ToList())
                {
                    if (i.sw.ElapsedMilliseconds < YELLOW_THRESHOLD &&
                        i.C.R < 230)
                        i.C = Color.FromArgb(255, i.C.R + 25, i.C.G, i.C.B);
                    else if (i.C.G > 25) // Elpased >= YELLOW_THRESHOLD
                        i.C = Color.FromArgb(255, i.C.R, i.C.G - 25, i.C.B);
                }
            }
            Canvas.Refresh();
        }

        public class Test
        {
            public Stopwatch sw;
            public int X;
            public int Y;
            public int R;

            public Color C;

            public static int counter = 0;

            public Test()
            {
                X = Y = R = 0;
            }

            public Test(int _X, int _Y, int _R)
            {
                X = _X;
                Y = _Y;
                R = _R;
                C = Color.Green;

                counter++;

                sw = new Stopwatch();
                sw.Start();
            }
        }

        private void Canvas_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            lock (poolLock)
            {
                foreach (Test i in pool)
                {
                    using (Brush myBrush = new SolidBrush(i.C))
                    {
                        g.FillCircle(myBrush, i.X, i.Y, i.R);
                    }
                }
                /*
                using (Brush myBrush = new SolidBrush(Color.Green))
                {
                    foreach (Test i in pool)
                    {
                        g.FillCircle(myBrush, i.X, i.Y, i.R);
                    }
                }
                */
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            generateTimer.Dispose();
        }

        private void Canvas_MouseDown(object sender, MouseEventArgs e)
        {

            lock (poolLock)
            {
                foreach (Test i in pool.ToList())
                {
                    if ( ((e.X - i.X) * (e.X - i.X)) +
                         ((e.Y - i.Y) * (e.Y - i.Y)) <= (i.R * i.R))
                    {
                        counter++;
                        totalTime += i.sw.ElapsedMilliseconds;

                        AverageTimeLabel.Text = String.Format("{0}.{1:000}", 
                                                (totalTime / counter) / 1000,
                                                (totalTime / counter) % 1000);

                        pool.Remove(i);
                        Canvas.Refresh();
                        break;
                    }
                }
            }
        }

        private void StartButton_Click(object sender, EventArgs e)
        {
            generateTimer.Enabled = true;
            colorTimer.Enabled = true;
        }
    }
    public static class GraphicsExtensions
    {
        public static void DrawCircle(this Graphics g, Pen pen,
                                      float centerX, float centerY, float radius)
        {
            g.DrawEllipse(pen, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }

        public static void FillCircle(this Graphics g, Brush brush,
                                      float centerX, float centerY, float radius)
        {
            g.FillEllipse(brush, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }
    }
}
