﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MouseExample
{
    public partial class Form1 : Form
    {
        public static Point alpha;
        public static Point beta;

        public static List<Point> allPoints;

        public Form1()
        {
            InitializeComponent();

            allPoints = new List<Point>();
        }

        private void Canvas_MouseDown(object sender, MouseEventArgs e)
        {
            //Coordinates_ListBox.Items.Add("(" + e.X + ", " + e.Y + ")");
            //Coordinates_ListBox.Items.Add(new Point(e.X, e.Y));
            alpha = new Point(e.X, e.Y);
        }

        private void Canvas_MouseUp(object sender, MouseEventArgs e)
        {
            beta = new Point(e.X, e.Y);
            allPoints.Add(alpha);
            allPoints.Add(beta);

            Coordinates_ListBox.Items.Add("Line: " + alpha);
            Coordinates_ListBox.Items.Add("    to " + beta);

            Canvas.Refresh();
        }

        private void Canvas_Paint(object sender, PaintEventArgs e)
        {
            if (alpha == null) return;

            Graphics g = e.Graphics;

            using (Pen myPen = new Pen(Color.BurlyWood))
            {
                for (int i = 0; i < allPoints.Count; i += 2)
                {
                    g.DrawLine(myPen, allPoints[i], allPoints[i + 1]);
                }
                //g.DrawLine(myPen, alpha, beta);
            }
        }
    }
}
