﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ICanShowYouTheWorld
{
    public partial class Form1 : Form
    {
        public static int R = 150;
        public static int theta = 0;
        public static int delta = 1;
        public static int TEMPLATE_DISPLACEMENT = 94;
        public static int SUN_RADIUS = 20;

        public static List<string> planet_labels;
        public static List<int> planet_label_x_offsets;
        public static List<int> planet_label_y_offsets;
        public static List<int> planet_radii;
        public static List<int> planet_orbit;
        public static List<int> planet_theta;
        public static List<int> planet_delta;

        public static int templates = 0;

        public static List<TrackBar> planetSpeeds;
        public static List<Label> templateLabels;

        public static System.Windows.Forms.Timer orbitTimer;
        public enum PlanetNames {Mercury, Venus, Earth, Mars};

        public Form1()
        {
            InitializeComponent();

            orbitTimer = new System.Windows.Forms.Timer();
            planet_labels = new List<string>();
            planet_label_x_offsets = new List<int>();
            planet_label_y_offsets = new List<int>();
            planet_radii = new List<int>();
            planet_orbit = new List<int>();
            planet_theta = new List<int>();
            planet_delta = new List<int>();

            planetSpeeds = new List<TrackBar>();
            templateLabels = new List<Label>();

            orbitTimer.Enabled = true;
            orbitTimer.Interval = 17;
            orbitTimer.Tick += new EventHandler(moveThePlanets);
        }

        public double DistanceFormula(int x0, int x1, int y0, int y1)
        {
            return Math.Sqrt( ((x0 - x1) * (x0 - x1)) +
                              ((y0 - y1) * (y0 - y1)));
        }

        public void moveThePlanets(object sender, EventArgs e)
        {
            for (int i = 0; i < templates; i++)
                planet_theta[i] += planet_delta[i];

            if (templates >= 2)
                DistanceLabel.Text = String.Format("{0}", DistanceFormula(
                                                          (int)((Canvas.Width / 2) + (planet_orbit[0] * Math.Cos(Math.PI * planet_theta[0] / 180))),
                                                          (int)((Canvas.Width / 2) + (planet_orbit[1] * Math.Cos(Math.PI * planet_theta[1] / 180))),
                                                          (int)((Canvas.Height / 2) + (planet_orbit[0] * Math.Sin(Math.PI * planet_theta[0] / 180))),
                                                          (int)((Canvas.Height / 2) + (planet_orbit[1] * Math.Sin(Math.PI * planet_theta[1] / 180)))));

            Canvas.Refresh();
        }

        private void Canvas_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            using (Brush sunBrush = new SolidBrush(Color.Yellow))
            {
                g.FillCircle(sunBrush, Canvas.Width / 2, Canvas.Height / 2, SUN_RADIUS);

                using (Brush nameBrush = new SolidBrush(Color.White))
                {
                    using (Font planetFont = new Font("Courier New", 12))
                    {
                        g.DrawString("The Sun", planetFont, nameBrush,
                                     new Point((int)((Canvas.Width / 2) - 38),
                                               (int)((Canvas.Height / 2) - 39)));
                    }
                }
            }

            for (int i = 0; i < templates; i++)
            {
                using (Pen myPen = new Pen(Color.White))
                {
                    g.DrawCircle(myPen, Canvas.Width / 2, Canvas.Height / 2, planet_orbit[i]); // This is the orbit

                    g.DrawCircle(myPen, (float)((Canvas.Width / 2) + (planet_orbit[i] * Math.Cos(Math.PI * planet_theta[i] / 180))),
                                        (float)((Canvas.Height / 2) + (planet_orbit[i] * Math.Sin(Math.PI * planet_theta[i] / 180))),
                                        planet_radii[i]); // This is the planet

                    // The planets label
                    using (Brush nameBrush = new SolidBrush(Color.White))
                    {
                        using (Font planetFont = new Font("Courier New", 12))
                        {
                            g.DrawString(planet_labels[i], planetFont, nameBrush,
                                         new Point((int)((Canvas.Width / 2) + (planet_orbit[i] * Math.Cos(Math.PI * planet_theta[i] / 180)) - planet_label_x_offsets[i]),
                                                   (int)((Canvas.Height / 2) + (planet_orbit[i] * Math.Sin(Math.PI * planet_theta[i] / 180))) - planet_label_y_offsets[i]));
                        }
                    }
                }
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            orbitTimer.Dispose();
        }

        private void PlanetSpeedChangeValue(object sender, EventArgs e)
        {
            if (sender == null) return;
            // else
            TrackBar slacker = sender as TrackBar;

            if (slacker != null)
            {
                for (int i = 0; i < planetSpeeds.Count; i++)
                {
                    if (slacker == planetSpeeds[i])
                        planet_delta[i] = slacker.Value;
                }
            }
            else
                return;
        }

        private void PlanetCounter_ValueChanged(object sender, EventArgs e)
        {
            if (templates < PlanetCounter.Value) // That is, we are ADDING templates
            {
                if (PlanetCounter.Value == 1)
                {
                    planet_labels.Add("Mercury");
                    planet_label_x_offsets.Add(27);
                    planet_label_y_offsets.Add(48);
                    planet_radii.Add(30);
                    planet_orbit.Add(100);
                    planet_theta.Add(theta);
                    planet_delta.Add(delta);
                }
                if (PlanetCounter.Value == 2)
                {
                    planet_labels.Add("Venus");
                    planet_label_x_offsets.Add(27);
                    planet_label_y_offsets.Add(48);
                    planet_radii.Add(30);
                    planet_orbit.Add(150);
                    planet_theta.Add(theta);
                    planet_delta.Add(delta);
                }
                if (PlanetCounter.Value == 3)
                {
                    planet_labels.Add("Earth");
                    planet_label_x_offsets.Add(27);
                    planet_label_y_offsets.Add(48);
                    planet_radii.Add(30);
                    planet_orbit.Add(200);
                    planet_theta.Add(theta);
                    planet_delta.Add(delta);
                }

                Canvas.Refresh();

                for (int i = templates; i < PlanetCounter.Value; i++)
                {
                    planetSpeeds.Add(new TrackBar());

                    planetSpeeds[i].BackColor = System.Drawing.Color.Black;
                    planetSpeeds[i].Location = new System.Drawing.Point(17, 143 + (i * TEMPLATE_DISPLACEMENT));
                    planetSpeeds[i].Name = "trackBar1";
                    planetSpeeds[i].RightToLeft = System.Windows.Forms.RightToLeft.No;
                    planetSpeeds[i].Size = new System.Drawing.Size(233, 45);
                    planetSpeeds[i].TabIndex = 0;
                    planetSpeeds[i].ValueChanged += new System.EventHandler(this.PlanetSpeedChangeValue);
                    this.Controls.Add(planetSpeeds[i]);

                    templateLabels.Add(new Label());
                    templateLabels.Add(new Label());
                    templateLabels.Add(new Label());

                    templateLabels[(i * 3)].AutoSize = true;
                    templateLabels[(i * 3)].Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
                    templateLabels[(i * 3)].ForeColor = System.Drawing.Color.DeepSkyBlue;
                    templateLabels[(i * 3)].Location = new System.Drawing.Point(39, 193 + (i * TEMPLATE_DISPLACEMENT));
                    templateLabels[(i * 3)].Name = "label2";
                    templateLabels[(i * 3)].Size = new System.Drawing.Size(41, 16);
                    templateLabels[(i * 3)].TabIndex = 5;
                    templateLabels[(i * 3)].Text = "Slow";
                    templateLabels[(i * 3)].BringToFront();

                    templateLabels[(i * 3) + 1].AutoSize = true;
                    templateLabels[(i * 3) + 1].Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
                    templateLabels[(i * 3) + 1].ForeColor = System.Drawing.Color.DeepSkyBlue;
                    templateLabels[(i * 3) + 1].Location = new System.Drawing.Point(209, 193 + (i * TEMPLATE_DISPLACEMENT));
                    templateLabels[(i * 3) + 1].Name = "label3";
                    templateLabels[(i * 3) + 1].Size = new System.Drawing.Size(38, 16);
                    templateLabels[(i * 3) + 1].TabIndex = 6;
                    templateLabels[(i * 3) + 1].Text = "Fast";
                    templateLabels[(i * 3)].BringToFront();

                    templateLabels[(i * 3) + 2].AutoSize = true;
                    templateLabels[(i * 3) + 2].Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
                    templateLabels[(i * 3) + 2].ForeColor = System.Drawing.Color.DeepSkyBlue;
                    templateLabels[(i * 3) + 2].Location = new System.Drawing.Point(16, 124 + (i * TEMPLATE_DISPLACEMENT));
                    templateLabels[(i * 3) + 2].Name = "label4";
                    templateLabels[(i * 3) + 2].Size = new System.Drawing.Size(64, 16);
                    templateLabels[(i * 3) + 2].TabIndex = 7;
                    templateLabels[(i * 3) + 2].Text = planet_labels[i];

                    this.Controls.Add(templateLabels[(i * 3)]);
                    this.Controls.Add(templateLabels[(i * 3) + 1]);
                    this.Controls.Add(templateLabels[(i * 3) + 2]);
                }
            }
            else // We are REMOVING templates
            {
                for (int i = templates; i > (int)PlanetCounter.Value; i--)
                {
                    this.Controls.Remove(planetSpeeds[i - 1]);
                    planetSpeeds.RemoveAt(i - 1);

                    this.Controls.Remove(templateLabels[((i - 1) * 3)]);
                    this.Controls.Remove(templateLabels[((i - 1) * 3) + 1]);
                    this.Controls.Remove(templateLabels[((i - 1) * 3) + 2]);

                    templateLabels.RemoveAt(((i - 1) * 3) + 2);
                    templateLabels.RemoveAt(((i - 1) * 3) + 1);
                    templateLabels.RemoveAt(((i - 1) * 3));
                }
            }

            templates = (int)PlanetCounter.Value;
        }
    }

    public static class GraphicsExtensions
    {
        public static void DrawCircle(this Graphics g, Pen pen,
                                      float centerX, float centerY, float radius)
        {
            g.DrawEllipse(pen, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }

        public static void FillCircle(this Graphics g, Brush brush,
                                      float centerX, float centerY, float radius)
        {
            g.FillEllipse(brush, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }
    }
}
