﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace GetRhythm
{
    public partial class Form1 : Form
    {
        public static int TARGET = 125;
        public static int NOTE_RADIUS = 40;
        public static int CANVAS_HEIGHT;
        public static int TRAVEL_DISTANCE = 5;
        public static int FAIL_DISTANCE = 45;
        public static int CLEAR_LABEL_X = 380;
        public static int CLEAR_LABEL_Y = 32;

        public static int PERFECT = 20;

        public static List<Note> allNotes;
        public static object notesLock = new object();
        public static List<char> UpKeys;
        public static List<char> DownKeys;

        public static Random rng;
        public static System.Windows.Forms.Timer animation;
        public static System.Windows.Forms.Timer noteCreation;
        public static System.Windows.Forms.Timer labelClearTimer;

        public class Note
        {
            public int X;
            public int Y;

            public Note()
            {
                X = Y = 0;
            }

            public Note(Boolean top, int _X)
            {
                X = _X;
                if (top)
                    Y = CANVAS_HEIGHT / 3;
                else
                    Y = (2 * CANVAS_HEIGHT / 3);
            }
        }

        public Form1()
        {
            InitializeComponent();

            ClearLabel.Text = "";

            CANVAS_HEIGHT = Canvas.Height;
            allNotes = new List<Note>();
            rng = new Random();
            UpKeys = new List<char>();
            DownKeys = new List<char>();

            UpKeys.Add('D');
            UpKeys.Add('F');
            UpKeys.Add('C');

            DownKeys.Add('J');
            DownKeys.Add('U');
            DownKeys.Add('K');

            animation = new System.Windows.Forms.Timer();

            animation.Enabled = true;
            animation.Interval = 17;
            animation.Tick += new EventHandler(MoveTheCircle);

            
            noteCreation = new System.Windows.Forms.Timer();

            noteCreation.Enabled = true;
            noteCreation.Interval = 2000;
            noteCreation.Tick += new EventHandler(CreateNewNote);

            lock (notesLock)
            {
                allNotes.Add(new Note(true, Canvas.Width));
            }

            labelClearTimer = new System.Windows.Forms.Timer();

            labelClearTimer.Enabled = true;
            labelClearTimer.Interval = 500;
            labelClearTimer.Tick += new EventHandler(ChangeLabel);
        }

        private void MoveTheCircle(object sender, EventArgs e)
        {
            lock (notesLock)
            {
                foreach (Note i in allNotes.ToList())
                {
                    if (i.X >= (TARGET - FAIL_DISTANCE))
                        i.X = (i.X - TRAVEL_DISTANCE);

                    if (i.X < (TARGET - FAIL_DISTANCE))
                        allNotes.Remove(i);
                }
            }
            Canvas.Refresh();
        }

        public void CreateNewNote(object sender, EventArgs e)
        {
            lock (notesLock)
            {
                allNotes.Add(new Note(true, Canvas.Width));
            }
            noteCreation.Enabled = false;
        }

        public void ChangeLabel(object sender, EventArgs e)
        {
            ClearLabel.Text = "";
            labelClearTimer.Enabled = false;
        }

        private void Canvas_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;

            using (Pen myPen = new Pen(Color.BurlyWood))
            {
                g.DrawLine(myPen, TARGET, 0, TARGET, Canvas.Height);

                lock (notesLock)
                {
                    if (allNotes.Count >= 1)
                    { 
                        if (allNotes[0].X >= (TARGET - FAIL_DISTANCE))
                            g.DrawCircle(myPen, allNotes[0].X, allNotes[0].Y, NOTE_RADIUS);

                        if (allNotes.Count == 2)
                        {
                            using (Brush holdPen = new SolidBrush(Color.AliceBlue))
                            {
                                g.FillRectangle(holdPen, allNotes[0].X, allNotes[0].Y - 10,
                                                allNotes[1].X - allNotes[0].X, 20);
                            }
                            g.DrawCircle(myPen, allNotes[1].X, allNotes[1].Y, NOTE_RADIUS);
                        }
                    }
                    /*
                    foreach (Note i in allNotes.ToList())
                    {
                        if (i.X >= (TARGET - FAIL_DISTANCE))
                            g.DrawCircle(myPen, i.X, i.Y, NOTE_RADIUS);

                        using (Brush holdPen = new SolidBrush(Color.AliceBlue))
                        {
                            g.FillRectangle(holdPen, i.X, i.Y - 10, 60, 20);
                        }
                    }
                    */
                }
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            animation.Dispose();
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            foreach (char i in UpKeys)
            {
                if ((char)e.KeyValue == i) // They pressed an UpKey
                {
                    lock (notesLock)
                    {
                        foreach (Note j in allNotes.ToList())
                        {
                            if (j.X >= (TARGET - PERFECT) &&
                                j.X <= (TARGET + PERFECT))
                            {
                                ClearLabel.Text = "Perfect!";
                                ClearLabel.Location = new Point(CLEAR_LABEL_X, CLEAR_LABEL_Y);
                                labelClearTimer.Enabled = true;
                                allNotes.Remove(j);
                                Canvas.Refresh();
                            }
                        }
                    }
                }
            }
            foreach (char i in DownKeys)
            {
                if ((char)e.KeyValue == i) // They pressed an DownKey
                {
                    lock (notesLock)
                    {
                        foreach (Note j in allNotes.ToList())
                        {
                            if (j.X >= (TARGET - PERFECT) &&
                                j.X <= (TARGET + PERFECT))
                            {
                                ClearLabel.Text = "Perfect!";
                                ClearLabel.Location = new Point(CLEAR_LABEL_X, CLEAR_LABEL_Y);
                                labelClearTimer.Enabled = true;
                                allNotes.Remove(j);
                                Canvas.Refresh();
                            }
                        }
                    }
                }
            }
            // If none of these are triggered, the user simply didn't press one of the defined
            // Up/Down keys
        }

        private void Form1_KeyUp(object sender, KeyEventArgs e)
        {
            foreach (char i in UpKeys)
            {
                if ((char)e.KeyValue == i) // They pressed an UpKey
                {
                    lock (notesLock)
                    {
                        foreach (Note j in allNotes.ToList())
                        {
                            if (j.X >= (TARGET - PERFECT) &&
                                j.X <= (TARGET + PERFECT))
                            {
                                ClearLabel.Text = "Perfect!";
                                ClearLabel.Location = new Point(CLEAR_LABEL_X, CLEAR_LABEL_Y);
                                labelClearTimer.Enabled = true;
                                allNotes.Remove(j);
                                Canvas.Refresh();
                            }
                        }
                    }
                }
            }
            foreach (char i in DownKeys)
            {
                if ((char)e.KeyValue == i) // They pressed an DownKey
                {
                    lock (notesLock)
                    {
                        foreach (Note j in allNotes.ToList())
                        {
                            if (j.X >= (TARGET - PERFECT) &&
                                j.X <= (TARGET + PERFECT))
                            {
                                ClearLabel.Text = "Perfect!";
                                ClearLabel.Location = new Point(CLEAR_LABEL_X, CLEAR_LABEL_Y);
                                labelClearTimer.Enabled = true;
                                allNotes.Remove(j);
                                Canvas.Refresh();
                            }
                        }
                    }
                }
            }
            // If none of these are triggered, the user simply didn't press one of the defined
            // Up/Down keys
        }

        /*
        private void textBox1_Enter(object sender, EventArgs e)
        {
            if (textBox1.Text.CompareTo("Phone Number") == 0) // The "shadow" is present
            {
                textBox1.Text = "";
                textBox1.ForeColor = Color.Black;
            }
        }

        private void textBox1_Leave(object sender, EventArgs e)
        {
            if (textBox1.Text.CompareTo("") == 0) // The user didn't enter anything
            {
                textBox1.Text = "Phone Number"; // Replace the "shadow"
                textBox1.ForeColor = Color.DarkGray;
            }
        }
        */
    }
    public static class GraphicsExtensions
    {
        public static void DrawCircle(this Graphics g, Pen pen,
                                      float centerX, float centerY, float radius)
        {
            g.DrawEllipse(pen, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }

        public static void FillCircle(this Graphics g, Brush brush,
                                      float centerX, float centerY, float radius)
        {
            g.FillEllipse(brush, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }
    }
}
