﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FlashCards
{
    public partial class Form1 : Form
    {
        public static Boolean question;
        public static Random rng;
        public static int index;
        public static int correctResponses;
        public static int totalResponses;
        public static List<FlashCards> fc;

        public static uint QUIZ_SIZE = 10;

        public class FlashCards
        {
            public string question;
            public string answer;
            public Boolean asked;

            public FlashCards()
            {
                question = answer = "";
                asked = false;
            }

            public FlashCards(string record)
            {
                question = "\n\n\n" + record.Split('#')[0];
                answer = "\n\n\n" + record.Split('#')[1];
                asked = false;
            }
        }
        public void DisplayFlashCard()
        {
            fc[index].asked = true;
            FlashCard.Text = fc[index].question;
            question = true;
        }

        public void FlipTheCard()
        {
            if (question)
            {
                FlashCard.Text = fc[index].answer;
                question = false;
            }
            else
            {
                FlashCard.Text = fc[index].question;
                question = true;
            }
        }

        public Form1()
        {
            InitializeComponent();

            FlashCard.SelectionAlignment = HorizontalAlignment.Center;
            question = true;
            rng = new Random();
            correctResponses = totalResponses = 0;

            fc = new List<FlashCards>();
            string slacker;
            try
            {
                using (StreamReader inFile = new StreamReader("..\\..\\cards.txt"))
                {
                    slacker = inFile.ReadLine();
                    while (slacker != null)
                    {
                        fc.Add(new FlashCards(slacker));
                        slacker = inFile.ReadLine();
                    }
                }
            }
            catch (FileNotFoundException e)
            {
                MessageBox.Show("Yeah that ain't the right path, chief.");
                Environment.Exit(-10);
            }
            //MessageBox.Show("There are " + fc.Count + " FlashCards available.");

            index = rng.Next(fc.Count);
            DisplayFlashCard();
        }

        private void FlashCard_Click(object sender, EventArgs e)
        {
            FlipTheCard();
        }

        private void ResponseButton_Click(object sender, EventArgs e)
        {
            progressBar1.PerformStep();

            if (sender == null) return;

            Button alpha = sender as Button;

            if (alpha == null) return; // The typecast failed
            // else, we can figure out which button was pressed
            if (alpha == RightButton)
                correctResponses++;
            // else, don't
            totalResponses++;

            PercentDisplay.ForeColor = Color.FromArgb(255,
                                                      255 - (int)(255 * ((float)correctResponses / totalResponses)),
                                                      (int)(255 * ((float)correctResponses / totalResponses)),
                                                      0);
            PercentDisplay.Text = String.Format("{0: 0%}", (float)correctResponses / totalResponses);

            if (totalResponses == QUIZ_SIZE)
            {
                HistoryBox.AppendText(PercentDisplay.Text);
                PercentDisplay.Text = "";
                correctResponses = totalResponses = 0;
                progressBar1.Value = 0;

                foreach (FlashCards i in fc)
                    i.asked = false;
            }

            index = rng.Next(fc.Count); // Trying to get another FC
            while (fc[index].asked)     // If we've already asked this FC, pick another one
                index = rng.Next(fc.Count);

            DisplayFlashCard();
        }

        private void SpaceBarFlipping(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Space)
                FlipTheCard();
        }
    }
}
