﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DarkCalculator
{
    public partial class Form1 : Form
    {
        public static UInt64? leftOp;
        public static UInt64 rightOp;
        public static char Operator;
        public static Boolean reset;

        public Form1()
        {
            InitializeComponent();

            Division_Button.Text = "\u00F7";
            leftOp = null;
            reset = false;
        }

        public UInt64 Convert_Results_String()
        {
            StringBuilder sb = new StringBuilder(Results_Textbox.Text);

            while (sb.ToString().IndexOf(',') != -1)
                sb.Remove(sb.ToString().IndexOf(','), 1);

            return Convert.ToUInt64(sb.ToString());
        }

        public void NumericKey_Click(object sender, EventArgs args)
        {
            if (sender == null) return;

            Button alpha = sender as Button;

            if (alpha == null) // The typecast failed
                return;

            if (reset)
            {
                Results_Textbox.Text = "";
                reset = false;
            }
            Results_Textbox.Text += (alpha.Text);

            if (Results_Textbox.Text.Length < 4) return;
            // else, we want to insert some commas

            Results_Textbox.Text = String.Format("{0:#,0}", Convert_Results_String());
        }

        public void Arithmetic_Button_Click(object sender, EventArgs args)
        {
            if (Results_Textbox.Text.CompareTo("") == 0) // The textbox is blank
                return;

            // else
            if (sender == null) return; // throw new NullArgumentException()

            Button alpha = sender as Button;

            if (alpha == null) // the typecast failed
                return;

            CurrentExpression_Textbox.Text = " " + alpha.Text + " " + Results_Textbox.Text + CurrentExpression_Textbox.Text;

            if (leftOp.HasValue) // if this is true, then we assign to rightOp
            {
                rightOp = Convert_Results_String();

                switch (Operator)
                {
                    case ('+'):
                        leftOp += rightOp;
                        break;
                    case ('-'):
                        leftOp -= rightOp;
                        break;
                    case ('*'):
                        leftOp *= rightOp;
                        break;
                    case ('\u00F7'):
                        leftOp /= rightOp;
                        break;
                }
                Results_Textbox.Text = String.Format("{0:#,0}", leftOp);
                reset = true;
                Operator = alpha.Text[0];
            }
            else // leftOp == null
            {
                leftOp = Convert_Results_String();
                Operator = alpha.Text[0];

                Results_Textbox.Text = "";
            }
        }

        private void Clear_Button_Click(object sender, EventArgs e)
        {
            Results_Textbox.Text = "";
        }

        private void ClearExpression_Button_Click(object sender, EventArgs e)
        {
            CurrentExpression_Textbox.Text = "";
            Results_Textbox.Text = "";
            leftOp = null;
        }
    }
}
